% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_constraints.R
\name{unitary_constraints}
\alias{unitary_constraints}
\title{Unitary constraints routine}
\usage{
unitary_constraints(X, epsilon = 0, ...)
}
\arguments{
\item{X}{Population matrix of the MOEA/D (each row is a candidate solution).
If \code{NULL} the function searches for \code{X} in the calling environment.}

\item{epsilon}{small non-negative value indicating the tolerance to be
considered for the equality constraint. Defaults to zero.}

\item{...}{other parameters (unused, included for compatibility with
generic call)}
}
\value{
List objective containing a matrix of constraint values \code{Cmatrix}, a
matrix of individual constraint violations \code{Vmatrix}, and a vector of total
constraint violations \code{v}.
}
\description{
Calculates the constraint values and violations when only unitary constraints
(i.e., the sum of all variables equals one) are present.
}
\details{
This routine calculates the constraint values and violations for a population
matrix in the MOEA/D. Each row of the matrix is considered as a candidate
solution. This routine expects the candidate solutions to be standardized,
i.e., that the variable limits given in \code{problem$xmin} and
\code{problem$xmax} are mapped to \code{0} and \code{1}, respectively.
}
