% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_process_indexes.R
\name{MODIStsp_process_indexes}
\alias{MODIStsp_process_indexes}
\title{MODIStsp helper for computing spectral indexes}
\usage{
MODIStsp_process_indexes(out_filename, out_prod_folder, formula, bandnames,
  nodata_out, indexes_nodata_out, file_prefix, compress, yy, out_format,
  DOY, scale_val)
}
\arguments{
\item{out_filename}{\code{character} basename of the file in to which save results}

\item{out_prod_folder}{\code{character} output folder for the product used to retrieve filenames
of rasters of original bands to be used in computations}

\item{formula}{\code{character} Index formula, as derived from XML file and stored in prod_opts
within previous_file}

\item{bandnames}{\code{character} array of names of original HDF layer. Used to identify the
bands required for index computation}

\item{nodata_out}{\code{character} array of NoData values of reflectance bands}

\item{indexes_nodata_out}{\code{character} NoData value for resulting raster}

\item{file_prefix}{\code{character} used to retrieve filenames of rasters of original bands
to be used in computations}

\item{compress}{\code{character} compression option for GTiff files}

\item{yy}{\code{character} year string used to retrieve filenames of rasters of original bands
to be used in computations}

\item{out_format}{\code{character} string used to retrieve filenames of rasters of original bands
to be used in computations}

\item{DOY}{\code{character} doy string used to retrieve filenames of rasters of original bands to be
used in computations}

\item{scale_val}{\code{character} (Yes/No) if Yes, output values in are computed as float -1 - 1,
otherwise integer -10000 - 10000}
}
\value{
NULL - new raster file saved in out_filename
}
\description{
function used to compute spectral indexes, given the index formula
}
\details{
the function parses the index formula to identify the required bands. On the basis
of identified bands, it retrieves the reflectance bands required, gets the data into R raster
objects, performs the computation and stores results in a GeoTiff or ENVI raster file
}
\note{
License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2017) \email{ranghetti.l@irea.cnr.it}
}
