% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportCoverage.R
\name{exportOpenTiles}
\alias{exportOpenTiles}
\title{\code{exportOpenTiles}}
\usage{
exportOpenTiles(SampleTileObject, cellPopulation, outDir, verbose = FALSE)
}
\arguments{
\item{SampleTileObject}{The SummarizedExperiment object output from
\code{getSampleTileMatrix}}

\item{cellPopulation}{The name of the cell population to export}

\item{outDir}{Desired output directory where bigBed files will be saved}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
outList A List of output filepaths
}
\description{
\code{exportOpenTiles} exports the open tiles of a given cell
 population to bigBed file for visualization in genome browsers.
}
\examples{
\dontrun{
MOCHA::exportOpenTiles(
  SampleTileObject = SampleTileObject,
  cellPopulation,
  outDir = tempdir(),
  verbose = TRUE
)
}

}
