% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl_fd_ova.R
\name{mnl_fd_ova}
\alias{mnl_fd_ova}
\title{Multinomial First Differences Prediction (Observed Value Approach)}
\usage{
mnl_fd_ova(
  model,
  data,
  x,
  z,
  z_values,
  xvari,
  scenname,
  scenvalues,
  by = NULL,
  nsim = 1000,
  seed = "random",
  probs = c(0.025, 0.975)
)
}
\arguments{
\item{model}{the multinomial model, from a \code{\link{multinom}}()-function call (see the \code{\link{nnet}} package)}

\item{data}{the data with which the model was estimated}

\item{x}{the name of the variable that should be varied (the x-axis variable in prediction plots)}

\item{z}{define the variable for which you want to compute the difference.}

\item{z_values}{determine the two values at which value you want to fix the scenario (\code{z}). The first differences will be computed by subtracting the values of the first supplied scenario from the second one.}

\item{xvari}{former argument for \code{x} (deprecated).}

\item{scenname}{former argument for \code{z} (deprecated).}

\item{scenvalues}{former argument for \code{z_values} (deprecated).}

\item{by}{define the steps of \code{x}.}

\item{nsim}{numbers of simulations}

\item{seed}{set a seed for replication purposes.}

\item{probs}{a vector with two numbers, defining the significance levels. Default to 5\% significance level: \code{c(0.025, 0.975)}}
}
\value{
The function returns a list with several elements. Most importantly the list includes the simulated draws `S`, the simulated predictions `P`, and a data set for plotting `plotdata`.
}
\description{
This function predicts values for two different scenarios over a range of
values. It then takes the differences between the different simulations to
return first differences for each value.
}
\details{
The function uses the \code{\link{mnl_pred_ova}} function for each scenario.
The results of these predictions are also returned and can therefore be
easily accessed. If you need predictions for multiple scenarios, you can use
this function to both plot the predictions for each scenario and the
differences between them.
}
\examples{
library(nnet)
library(MASS)

dataset <- data.frame(y = c(rep("a", 10), rep("b", 10), rep("c", 10)),
                      x1 = rnorm(30),
                      x2 = rnorm(30, mean = 1),
                      x3 = sample(1:10, 30, replace = TRUE))

mod <- multinom(y ~ x1 + x2 + x3, data = dataset, Hess = TRUE)

fdif <- mnl_fd_ova(model = mod, data = dataset,
                   x = "x1", z = "x3",
                   z_values = c(min(dataset$x3), max(dataset$x3)),
                   nsim = 10)

}
