% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.R
\name{pathway}
\alias{pathway}
\title{Pathway case}
\usage{
pathway(full_model, reduced_model)
}
\arguments{
\item{full_model}{Full model including covariate of interest
(= pathway variable)}

\item{reduced_model}{Reduced model excluding covariate of interest}
}
\value{
A dataframe with

- all full model variables,

- full model residuals (\code{full_resid}),

- reduced model residuals (\code{reduced_resid}),

- pathway values following Weller/Barnes (\code{pathway_wb}),

- pathway values following Gerring (\code{pathway_gvalue}),

- variable showing whether Gerring's criterion for a pathway
case is met (\code{pathway_gstatus})
}
\description{
Calculation of pathway values, defined as the difference between residuals of
full model and reduced model lacking the pathway variable. The larger the
difference, the more a case qualifies as a pathway case suitable for the
analysis of mechanisms.
}
\details{
The difference between the absolute residuals of the full and reduced model
follows the approach developed by Weller and Barnes (2014): \emph{Finding
Pathways: Mixed-Method Research for Studying Causal Mechanisms.}
Cambridge: Cambridge University Press.
\url{https://doi.org/10.1017/CBO9781139644501}).

The calculation of the absolute difference between the full-model and
reduced-model residuals, given a case's reduced-model residual is larger
than its full-model residual, follows the proposal by
Gerring (2007): Is There a (Viable) Crucial-Case Method?
\emph{Comparative Political Studies} 40 (3): 231-253.
\url{https://journals.sagepub.com/doi/10.1177/0010414006290784})
}
\examples{
df_full <- lm(mpg ~ disp + wt, data = mtcars)
df_reduced <- lm(mpg ~ wt, data = mtcars)
pathway(df_full, df_reduced)

}
