% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviant.R
\name{most_deviant}
\alias{most_deviant}
\title{Identification of the most deviant case}
\usage{
most_deviant(lmobject)
}
\arguments{
\item{lmobject}{Object generated with \code{\link[stats]{lm}}}
}
\value{
The most deviant case with the largest absolute
residual of all cases.
}
\description{
Identification of the most deviant case (= worst predicted case),
based on regression estimates.
}
\details{
Proposed by Seawright, Jason and John Gerring (2008):
Case Selection Techniques in Case Study Research: A Menu of
Qualitative and Quantitative Options. \emph{Political Research Quarterly}
61 (2): 294-308.
(\url{https://journals.sagepub.com/doi/pdf/10.1177/1065912907313077})
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
most_deviant(df)
}
