% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.MLGL}
\alias{print.MLGL}
\title{Print Values

Print a \code{\link{MLGL}} object}
\usage{
\method{print}{MLGL}(x, ...)
}
\arguments{
\item{x}{\code{\link{MLGL}} object}

\item{...}{Not used.}
}
\description{
Print Values

Print a \code{\link{MLGL}} object
}
\examples{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[,c(2,7,12)]\%*\%c(2,2,-2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- MLGL(X,y)
print(res)

}
\seealso{
\link{MLGL} \link{summary.MLGL}
}
