% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.stability.MLGL}
\alias{plot.stability.MLGL}
\title{Plot the stability path obtained from \code{\link{stability.MLGL}} function}
\usage{
\method{plot}{stability.MLGL}(x, log.lambda = FALSE, threshold = 0.75, ...)
}
\arguments{
\item{x}{\code{\link{stability.MLGL}} object}

\item{log.lambda}{If TRUE, use log(lambda) instead of lambda in abscissa}

\item{threshold}{Threshold for selection frequency}

\item{...}{Other parameters for plot function}
}
\value{
A list containing :
\describe{
\item{var}{Index of selected variables for the given threshold.}
\item{group}{Index of the associated group.}
\item{threshold}{Value of threshold}
}
}
\description{
Plot the stability path obtained from \code{\link{stability.MLGL}} function
}
\examples{
\donttest{
set.seed(42)
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
X <- simuBlockGaussian(50, 12, 5, 0.7)

# Generate a response variable
y <- X[,c(2,7,12)]\%*\%c(2,2,-2) + rnorm(50, 0, 0.5)

# Apply stability.MLGL method
res <- stability.MLGL(X, y)
selected <- plot(res)
print(selected)
}

}
\seealso{
\link{stability.MLGL}
}
