\name{MLE of continuous univariate distributions defined on the positive line}
\alias{positive.mle}
\title{
MLE of continuous univariate distributions defined on the positive line}

\description{
MLE of continuous univariate distributions defined on the positive line.
}

\usage{
positive.mle(x, distr = "gamma", tol = 1e-07, maxiters = 100)
}

\arguments{
\item{x}{
A vector with positive valued data (zeros are not allowed).
}
\item{distr}{
The distribution to fit. "gamma" stands for the gamma distribution, "chisq" for the \eqn{\chi^2} distribution, "weibull" for the Weibull, "lomax" for the Lomax, "foldnorm" for the folded normal, "betaprime" for the beta-prime distribution, "lognorm" for the log-normal, "logcauchy" for the log-Cauchy, "loglogictic" for the log-logistic distribution. "halfnorm" for the half-normal, "invgauss" for the inverse Gaussian, "pareto" for the Pareto distribution, "exp" for the exponential distribution, "exp2" I do not remember, "maxboltz" for the Maxwell-Boltzman distribution, "rayleigh" is the Rayleigh distribution, "lindley" is the Lindley distribution, "halfcauchy" is the half-Cauchy distribution and "powerlaw" is the power law distribution. The "normlog" is simply the normal distribution where all values are positive. Note, this is not log-normal. It is the normal with a log link. Similarly to the inverse gaussian distribution where the mean is an exponentiated. This comes from the GLM theory. The "epois" stands for the exponential-Poisson, the "gep" for the generalized exponential-Poisson and the "pe" for the Poisson-exponential distribution. The "wp" for the Weibull Poisson, the "be" for the beta exponential the "zigamma" and "ziweibull" stand for the zero inflated gamma and Weibull distributions, respectively, and they accept zeros.
}
\item{tol}{
The tolerance level up to which the maximisation stops; set to 1e-07 by default.
}
\item{maxiters}{
The maximum number of iterations the Newton-Raphson will perform.
}
}

\details{
Instead of maximising the log-likelihood via a numerical optimiser we have used a Newton-Raphson algorithm which is faster. See wikipedia for the equations to be solved.
For the t distribution we need the degrees of freedom and estimate the location and scatter parameters.

}

\value{
Usually a list with three elements, but this is not for all cases.
\item{iters}{
The number of iterations required for the Newton-Raphson to converge.}
\item{loglik}{
The value of the maximised log-likelihood.
}
\item{param}{
The vector of the parameters.
}
}

\references{
Kalimuthu Krishnamoorthy, Meesook Lee and Wang Xiao (2015). Likelihood ratio tests for comparing several gamma distributions. Environmetrics, 26(8):571--583.

N.L. Johnson, S. Kotz and N. Balakrishnan (1994). Continuous Univariate Distributions, Volume 1 (2nd Edition).

N.L. Johnson, S. Kotz a nd N. Balakrishnan (1970). Distributions in statistics: continuous univariate distributions, Volume 2.

Tsagris M., Beneki C. and Hassani H. (2014). On the folded normal distribution. Mathematics, 2(1):12--28.

Sharma V. K., Singh S. K., Singh U. and Agiwal V. (2015). The inverse Lindley distribution:
a stress-strength reliability model with application to head and neck cancer data. Journal of
Industrial and Production Engineering, 32(3): 162--173.

Barreto-Souza W. and Cribari-Neto F. (2009). A generalization of the exponential-Poisson distribution.
Statistics and Probability Letters, 79(24): 2493--2500.

Louzada F., Ramos P. L. and Ferreira H. P. (2020). Exponential-Poisson distribution: estimation and applications to rainfall and aircraft data with zero occurrence.
Communications in Statistics--Simulation and Computation, 49(4): 1024--1043.

Rodrigues G. C., Louzada F. and Ramos P. L. (2018). Poisson-exponential distribution: different methods of estimation. Journal of Applied Statistics, 45(1): 128--144.

Taylor S. and Pollard K. (2009). Hypothesis Tests for Point-Mass Mixture Data with Application to Omics Data with Many Zero Values. Statistical Applications in Genetics and Molecular Biology, 8(1): 1--43.

Percontini A., Blas B. and Cordeiro G. M. (2013). The beta Weibull Poisson distribution. Chilean Journal of Statistics, 4(2): 3--26.

Mahmoudi E., Zamani H. and Meshkat R. (2018). Poisson-beta exponential distribution: properties and applications. Journal of Statistical Research of Iran, 15(1): 119--146.

You can also check the relevant wikipedia pages for these distributions.
}

\author{
Michail Tsagris and Sofia Piperaki.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr} and Sofia Piperaki  \email{sofiapip23@gmail.com}.
}

\seealso{
\code{ \link{disc.mle}, \link{real.mle}, \link{prop.mle}
}
}

\examples{
x <- rgamma(100, 3, 4)
positive.mle(x, distr = "gamma")
}
