\name{save.model}
\alias{save.model}
\title{Save WinBUGS results in a specified directory}
\description{
	\code{save.model} saves several files resulting from a WinBUGS MCMC simulation to a specified directory. The saved items
	include the BUGS model file, the R script used to launch WinBUGS via the \code{R2WinBUGS} function \code{bugs}, and
	the R object generated by \code{bugs} that contains the MCMC simulations. Some additional intermediate files are also
	saved if they have not been deleted by \code{bugs}.
}
\usage{
save.model(bugs.output, model.name, parent.dir = ".")
}
\arguments{
  \item{bugs.output}{list object produced by \code{bugs}. See documentation of \code{R2WinBUGS} for details.}
  \item{model.name}{character string for name of the BUGS language model file minus the \code{.txt} extension. This will
  	also be the name of the directory to which the files are saved.}
  \item{parent.dir}{charater string for the name of an already existing directory that will be the parent directory for the
  	new "model.name" directory. Default is the current working directory.}
}
\details{
	Successfukl use of \code{save.model} requires that the BUGS language model file and the R script in which it is used have
	the names paste(model.name,".txt",sep="") and paste(model.name,".R",sep=""), respectively.
}
\references{ MIfuns package available from Metrum Institute website (\code{http://metruminstitute.org/}). }
\author{ Developed by Metrum Institute (Bill Gillespie and others). }
\keyword{manip}% __ONLY ONE__ keyword per line
