% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{genome_to_libsvm}
\alias{genome_to_libsvm}
\title{Converts a genome to kmers stored in libsvm format on disk}
\usage{
genome_to_libsvm(
  x,
  target_path,
  label = as.character(c("0")),
  k = 3L,
  canonical = TRUE,
  squeeze = FALSE
)
}
\arguments{
\item{x}{genome in string format}

\item{target_path}{path to store libsvm file (.txt)}

\item{label}{libsvm label}

\item{k}{kmer length}

\item{canonical}{only record canonical kmers
(i.e., the lexicographically smaller of a kmer and its reverse complement)}

\item{squeeze}{remove non-canonical kmers}
}
\value{
boolean indicating success
}
\description{
This function converts a single genome to a libsvm file containing kmer
counts. The libsvm format will be as follows:

\preformatted{
  label 1:count 2:count 3:count ...
}
Label is optional and defaults to 0. The kmer counts are indexed by the
kmer index, which is the lexicographically sorted index of the kmer.
Libsvm is a sparse format.
}
\examples{
temp_libsvm_path <- tempfile(fileext = ".txt")
genome_to_libsvm("ATCGCAGT", temp_libsvm_path)
readLines(temp_libsvm_path)
}
\seealso{
For multiple genomes in a directory, processed in parallel, see \code{\link[=genomes_to_kmer_libsvm]{genomes_to_kmer_libsvm()}}

For more details on libsvm format, see
\url{https://xgboost.readthedocs.io/en/stable/tutorials/input_format.html}
}
