% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PapaDiv_func_20230630.R
\name{PapaDiv}
\alias{PapaDiv}
\title{PapaDiv() function}
\usage{
PapaDiv(parents_table, seq_table, path_out)
}
\arguments{
\item{parents_table}{is a table containing the sample names of the parents in
each nest. This table should be organized so that each row represents one
nest, with the individual names of the mothers in the first column
(Mother), and the individual names of the fathers in the second column
(Father).}

\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
a set of R lists containing for the joint diversity of each parent
  pair, the proportion of sequences that are shared between the parents, the
  diversity of each of the parents, the observed sequence variants in each
  parent, the matched sequence variants, and the incongruent sequence
  variants in each parent. The sequences are named in the output by an index
  number corresponding to their column number in the sequence table, thus
  identical sequences will have identical sample names in all the output
  files. These files are saved in a sub folder in the output path called
  Parent_pairs (created by PapaDiv()) and can be reopened in R e.g. using
  the readRDS() function in the base package. For downstream data analysis,
  the PapaDiv() function also produces a summary table with the names of the
  parents in a pair, their respective MHC diversities, and the joint parent
  pair diversity. This table is saved as a .csv file in the output path.
}
\description{
\code{\link{PapaDiv}} calculates the joint major histocompatibility complex
(MHC) diversity in parent pairs, taking into account alleles that are shared
between the parents. The joint diversity in parent pairs is often of interest
in studies of mate choice, fitness, and heritability.
}
\details{
The PapaDiv() function outputs a set of R lists containing for the joint
diversity of each parent pair, the proportion of sequences that are shared
between the parents, the diversity of each of the parents, the observed sequence
variants in each parent, the matched sequence variants, and the incongruent
sequence variants in each parent.

In addition, PapaDiv() produces a summary table with the names of the parents in
a pair, their respective MHC diversities, and the joint parent pair diversity.

If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools - an R package for MHC high-throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non-model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
parents_table <- parents_table
seq_table <- sequence_table
path_out <- tempdir()
PapaDiv(parents_table, seq_table, path_out)
}
\seealso{
For more information about 'dada2' visit
  <https://benjjneb.github.io/dada2/>
}
