#' GetHpltStats() function
#'
#' \code{\link{GetHpltStats}} uses the output files produced by the HpltFind()
#' function to calculate the mean of the mean proportion of incongruent
#' sequences across all nests in the data set.
#'
#' If you publish data produced with MHCtools, please cite:
#' Roved, J. 2020. MHCtools: Analysis of MHC data in non-model species. Cran.
#' Roved, J., Hansson, B., Stervander, M., Hasselquist, D., Westerdahl, H. 2020.
#' Non-random association of MHC-I alleles in favor of high diversity haplotypes
#' in wild songbirds revealed by computer-assisted MHC haplotype inference using
#' the R package MHCtools. bioRxiv.
#'
#' @param filepath is a user defined path to the folder where the output files
#'   from the HpltFind() function have been saved.
#' @return  A mean of the mean proportion of incongruent sequences for each
#'   nest.
#' @seealso \code{\link{HpltFind}}; \code{\link{GetHpltTable}}
#' @examples
#' filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
#' GetHpltStats(filepath)
#' @export

GetHpltStats <- function(filepath) {

  # Get the file names of the .Rds output generated by the HpltFind function

  file_names <- dir(filepath)

  mean_props <- numeric()

  # Extract the mean proportion of incongruent sequences for each nest

  for(i in 1:length(file_names)) {

    mean_props[i] <- readRDS(file.path(filepath, file_names[i]))$Mean_prop_incongr_seqs

  }

  # Calculate the mean

  MoM_props <- mean(mean_props)

  MoM_props

}
