#' GetHpltStats() function
#'
#' \code{\link{GetHpltStats}} uses the output files produced by the HpltFind()
#' function to calculate the mean of the mean proportion of incongruent
#' sequences across all nests in the data set.
#'
#' @param filepath is a user defined path to the folder where the output files
#'   from the HpltFind() function have been saved.
#' @return  A mean of the mean proportion of incongruent sequences for each
#'   nest.
#' @seealso \code{\link{HpltFind}}; \code{\link{GetHpltTable}}
#' @examples
#' filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
#' GetHpltStats(filepath)
#' @importFrom "rlist" "list.load"
#' @export

GetHpltStats <- function(filepath) {

  # Get the file names of the .rdata output generated by the HpltFind function

  file_names <- dir(filepath)

  mean_props <- numeric()

  # Extract the mean proportion of incongruent sequences for each nest

  for(i in 1:length(file_names)) {

    mean_props[i] <- list.load(file.path(filepath, file_names[i]))$Mean_prop_incongr_seqs

  }

  # Calculate the mean

  MoM_props <- mean(mean_props)

  MoM_props

}
