% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Auxiliary.R
\name{splitOutput}
\alias{splitOutput}
\title{Split Output by Patch}
\usage{
splitOutput(readDir, writeDir = NULL, remFile = TRUE, verbose = TRUE)
}
\arguments{
\item{readDir}{Directory where output was written to}

\item{writeDir}{Directory to write output to. Default is readDir}

\item{remFile}{Remove original output? Default is TRUE}

\item{verbose}{Chatty? Default is TRUE}
}
\description{
Split output into multiple files by patches.
}
\examples{
\dontrun{
# This example assumes user has already run MGDrivE and generated output.
#  If that's untree, see vignette for complete example
fPath <- "path/to/data/containing/folder"
oPath <- "path/to/write/output"

# split data by patch, keep original files
#  no return value
splitOutput(readDir = fPath, writeDir = oPath, remFile = FALSE)

# Alternatively, remove the original files and write new ones in their place
fPath <- "path/to/data/containing/folder"

splitOutput(readDir = fPath, writeDir = NULL, remFile = TRUE)
}

}
