% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Graphics.R
\name{plotMGDrivEMult}
\alias{plotMGDrivEMult}
\title{Plot}
\usage{
plotMGDrivEMult(readDir, whichPatches = NULL, totalPop = FALSE,
                       nonZeroGen = FALSE, lwd = 0.75, alpha = 0.75)
}
\arguments{
\item{readDir}{Directory to find repetition folders in}

\item{whichPatches}{Vector of patches to plot, must be less than 15. Default is NULL if less than 15 patches}

\item{totalPop}{Boolean, to plot the total population or not. Default is FALSE}

\item{nonZeroGen}{Boolean, to plot genotypes that are always zero in simulation}

\item{lwd}{Double, specify the line width for plotting}

\item{alpha}{Double, specify the opacity for plotting}
}
\description{
Plots several traces from MGDrivE, assuming each set is another repetition
from the same experiment. \cr
Given the readDir, this function assumes the follow file structure: \cr
\itemize{
\item readDir
\itemize{
\item repetition 1
\itemize{
\item patch 1
\item patch 2
\item patch 3
}
\item repetition 2
\itemize{
\item patch 1
\item patch 2
\item patch 3
}
\item repetition 3
\item repetition 4
\item ...
}
}
}
\details{
This function plots output from one run or one set of runs after
being analyzed. Setting totalPop to FALSE keeps it from plotting the total
population. NonZeroGen accounts for genotypes that could exist, but are not
created in the simulation. Default is FALSE, as this is easier to read on a plot.
}
\examples{
\dontrun{
# Requires the user to have run MGDrivE, logically stochastic, analyzed
#  the data, and stored it in the directory shown below.
# See vignette for complete example

# Folder where single run is stored
fPath <- "path/to/data/containing/folder"

# plot output to see effect
plotMGDrivEMult(readDir=fPath,totalPop = TRUE,lwd=3.5,alpha=1)
}

}
