% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ClvR.R
\name{cubeClvR}
\alias{cubeClvR}
\title{Inheritance Cube: ClvR (Cleave and Rescue)}
\usage{
cubeClvR(
  cF = 1,
  crF = 0,
  ccF = cF,
  ccrF = crF,
  cM = 1,
  crM = 0,
  ccM = cM,
  ccrM = crM,
  dW = 0,
  drW = 0,
  ddW = dW,
  ddrW = drW,
  hSuf = 1,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cF}{Female cutting rate, one ClvR allele}

\item{crF}{Female functional resistance rate, one ClvR allele}

\item{ccF}{Female cutting rate, two ClvR alleles}

\item{ccrF}{Female functional resistance rate, two ClvR alleles}

\item{cM}{Male cutting rate, one ClvR allele}

\item{crM}{Male functional resistance rate, one ClvR allele}

\item{ccM}{Male cutting rate, two ClvR alleles}

\item{ccrM}{Male functional resistance rate, two ClvR alleles}

\item{dW}{Female deposition cutting rate}

\item{drW}{Female deposition functional resistance rate}

\item{ddW}{Female deposition (HH) cutting rate}

\item{ddrW}{Female deposition (HH) functional resistance rate}

\item{hSuf}{Haplosufficiency level, default is completely sufficient}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
Based on the Cleave-and-Rescue system of \href{https://doi.org/10.1073/pnas.1921698117}{Oberhofer},
this is a 2-locus Cas9-based toxin-antidote system. The first locus carries the
Cas9, gRNAs, and a recoded copy of an essential gene. The second locus is the
targeted essential gene. This gene can be completely haplosufficient (\code{hSuf} = 1)
or completely haploinsufficient (\code{hSuf} = 0). It is assumed that having
2 copies of the gene (be it wild-type at the second locus or recoded at the first)
confers complete viability.
}
