% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Auxiliary.R
\name{aggregateOutput}
\alias{aggregateOutput}
\title{Aggregate Output Over Landscape}
\usage{
aggregateOutput(readDir, writeDir=NULL)
}
\arguments{
\item{readDir}{Directory where output was written to}

\item{writeDir}{Directory to write output to. Default is one level above readDir}
}
\description{
This function aggregates the output of a run over the entire output, i.e., all
of the patches. It writes the output one level above the folder pointed to by
readDir, if writeDir is NULL. Output consists of 2 csv files, one for males and
one for females, "...M_LandscapeAgg_Run...csv".
}
\examples{
\dontrun{
# This assumes user has run MGDrivE and output is in fPath.
#  See vignette for examples on how to run MGDrivE

# read/write dirs
fPath <- "folder/containing/output"
oPath <- "folder/to/write/stuff"

# first, split output by patch and aggregate females by mate genotype
# remember, cube is for example and changes with simulation
#  landscape aggregation will work if females are not aggregated, but it's slower
cube <- cubeMendelian()

splitOutput(readDir = fPath, writeDir = NULL, remFile = TRUE)
aggregateFemales(readDir= fPath, writeDi = NULL, genotypes = cube$genotypesID,
                 remFile = TRUE)

# aggregate mosquitoes over entire landscape
#  no return value
aggregateOutput(readDir = fPath, writeDir = NULL)
}

}
