% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Releases.R
\name{basicRepeatedReleases}
\alias{basicRepeatedReleases}
\title{Make List of Modified Mosquito Releases}
\usage{
basicRepeatedReleases(releaseStart, releaseEnd, releaseInterval, releaseMatrix)
}
\arguments{
\item{releaseStart}{Day releases start}

\item{releaseEnd}{Day releases end}

\item{releaseInterval}{Interval between releases}

\item{releaseMatrix}{Numeric matrix specifying the genotype and release amount}
}
\description{
Sets up a release schedule for a single patch, returns a list to be used in
\code{\link{oneDay_releases_Patch}} or \code{\link{oneDay_eggReleases_Patch}}.
This function is no longer intended to be used alone, please use the standard
interface, \code{\link{generateReleaseVector}}.
}
\examples{
\dontrun{
# Setup for 3 patches but only release in the first with a defined release
#  schedule, for the cube cubeHomingDrive:

patchReleases = replicate(n = 3, expr = {
  list(maleReleases = NULL, femaleReleases = NULL, eggReleases = NULL, matedFemaleReleases = NULL)
},simplify = FALSE)

patchReleases[[1]]$femaleReleases = MGDrivE::basicRepeatedReleases(releaseStart = 5,
                                                          releaseEnd = 30,
                                                          releaseInterval = 5,
                                                          releaseMatrix = matrix(c(5,100),1,2))

patchReleases[[1]]$maleReleases = MGDrivE::basicRepeatedReleases(releaseStart = 50,
                                                        releaseEnd = 60,
                                                        releaseInterval = 1,
                                                        releaseMatrix = matrix(c(5,100),1,2))
}

}
