% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_asdp.R
\name{MFKnockoffs.knocks.solve_asdp}
\alias{MFKnockoffs.knocks.solve_asdp}
\title{Optimization for SDP knockoffs}
\usage{
MFKnockoffs.knocks.solve_asdp(Sigma, nBlocks = 10, cores = 1, eps = 0.001,
  max_iters = 2500)
}
\arguments{
\item{Sigma}{A positive-definite correlation matrix}

\item{nBlocks}{Number of blocks in the block-diagonal approximation of Sigma (default: 10)}

\item{cores}{Number of cores used to solve the smaller SDPs (default: 1)}

\item{eps}{Numeric    convergence tolerance for the conic solver (default: 1e-3)}

\item{max_iters}{The maximum number of iterations for the conic solver (default: 2500)}
}
\value{
The solution \eqn{s} to the semidefinite programming problem defined above
}
\description{
Solves the optimization problem needed to create approximate SDP knockoffs
}
\details{
Solves the following two-step semidefinite programming problem:

  (step 1)  \deqn{ \mathrm{maximize}     \; \mathrm{sum}(s) \quad
                   \mathrm{subject} \; \mathrm{to:}  \; 0 <= s <= 1, \;
                                         2 \Sigma_{\mathrm{approx}} - \mathrm{diag}(s) >= 0}
                             
  (step 2) \deqn{ \mathrm{maximize}      \; \gamma \quad
                  \mathrm{subject} \; \mathrm{to:}    \; \mathrm{diag}(\gamma s) <= 2 \Sigma}

If the matrix Sigma supplied by the user is a non-scaled covariance matrix 
(i.e. its diagonal entries are not all equal to 1), then the appropriate scaling is applied before
solving the SDP defined above. The result is then scaled back before being returned, as to match 
the original scaling of the covariance matrix supplied by the user.
}
\seealso{
Other Optimize knockoffs: \code{\link{MFKnockoffs.knocks.solve_equi}},
  \code{\link{MFKnockoffs.knocks.solve_sdp}}
}
