% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.t.test.R
\name{power_t_test}
\alias{power_t_test}
\title{Power calculations for one and two sample t tests with unequal sample size}
\usage{
power_t_test(
  n = NULL,
  delta = NULL,
  sd = 1,
  sig.level = 0.05,
  power = NULL,
  ratio = 1,
  sd.ratio = 1,
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "one.sided"),
  df.method = c("welch", "classical"),
  strict = TRUE
)
}
\arguments{
\item{n}{Number of observations (in the smallest group if two groups)}

\item{delta}{True difference in means}

\item{sd}{Standard deviation}

\item{sig.level}{Significance level (Type I error probability)}

\item{power}{Power of test (1 minus Type II error probability)}

\item{ratio}{The ratio n2/n1 between the larger group and the smaller group. Should be a value equal to or greater than 1 since n2 is the larger group. Defaults to 1 (equal group sizes). If ratio is set to NULL (i.e., find the ratio) then the ratio might be smaller than 1 depending on the desired power and ratio of the sd's.}

\item{sd.ratio}{The ratio sd2/sd1 between the standard deviations in the larger group and the smaller group. Defaults to 1 (equal standard deviations in the two groups)}

\item{type}{Type of t test}

\item{alternative}{One- or two-sided test}

\item{df.method}{Method for calculating the degrees of default. Possibilities are welch (the default) or classical.}

\item{strict}{Use strict interpretation in two-sided case. Defaults to TRUE unlike the standard power.t.test function.}
}
\value{
Object of class \code{power.htest}, a list of the arguments (including the computed one)
augmented with \code{method} and \code{note} elements.
}
\description{
Compute power of test, or determine parameters to obtain target
power for equal and unequal sample sizes.
}
\details{
Exactly one of the parameters \code{n}, \code{delta}, \code{power}, \code{sd}, \code{sig.level}, \code{ratio} \code{sd.ratio}
must be passed as NULL,
and that parameter is determined from the others. Notice that the last two have non-NULL defaults
so NULL must be explicitly passed if you want to compute them.

The default \code{strict = TRUE} ensures that the power will include the probability
of rejection in the opposite direction of the true effect, in the
two-sided case. Without this the power will be half the
significance level if the true difference is zero.
}
\note{
\code{uniroot} is used to solve power equation for unknowns, so you may
see errors from it, notably about inability to bracket the root
when invalid arguments are given.
}
\examples{
# Sampling with a ratio of 1:4
power_t_test(delta=300, sd=450, power=.8, ratio=4)

# Equal group sizes but different sd's
# The sd in the first group is twice the sd in the second group
power_t_test(delta=300, sd=450, power=.8, sd.ratio=.5)

# Fixed group one size to 50 individuals, but looking for the number of individuals in the
# second group. Different sd's with twice the sd in the larger group
power_t_test(n=50, delta=300, sd=450, power=.8, ratio=NULL, sd.ratio=2)
}
\seealso{
\code{\link{power.t.test}}, \code{\link{power_prop_test}}, \code{\link{power.prop.test}}
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{htest}
