%  Copyright (C) 2015 Christian Margreitter
\name{xrmsd}
\alias{xrmsd}
\title{XRMSD plot in heatmap style}
\description{Plots an heatmap according to the RMSD values for a 2D snapshot matrix, based on molecular dynamics trajectories.}
\usage{
xrmsd( xrmsdValues,
       printLegend = TRUE,
       xaxisRange = NA,
       yaxisRange = NA,
       colours = NA,
       barePlot = FALSE,
       ... )}
\arguments{
  \item{xrmsdValues}{Input matrix (three rows: x-values, y-values, RMSD-value). Can be generated by function \code{\link{load_xrmsd}()}.}
  \item{printLegend}{If \code{TRUE}, a legend is printed on the right hand side of the plot.}
  \item{xaxisRange}{A vector of boundaries for the x-snapshots.}
  \item{yaxisRange}{A vector of boundaries for the y-snapshots.}
  \item{colours}{A vector with colour names for the span palette.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\examples{
\dontrun{
# see "extdata/xrmsd_example.txt.gz" for format information
xrmsd( load_xrmsd( system.file( "extdata/xrmsd_example.txt.gz", package = "MDplot" ) ) )
}}
\author{Christian Margreitter}
\keyword{xrmsd}
