% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{map.to.interval}
\alias{map.to.interval}
\title{Map points from MDS final configuration to interval starting at 0.}
\usage{
map.to.interval(mdsobject, nloci)
}
\arguments{
\item{mdsobject}{The output from \code{\link[smacof]{smacofSphere}}.}

\item{nloci}{The number of markers in the configuration.}
}
\value{
A list with the elements:
\item{chromlength}{A named vector giving the position of each marker.}
\item{order}{A named vector giving the rank order of the markers.}
\item{locilength}{A named vector giving the position of each marker in order 
of increasing distance along the segment.}
\item{maporder}{A named vector of the position in the input list of each 
marker in order of increasing distance along the segment.}
}
\description{
Maps points from the final configuration of a 2-dimensional spherically 
constrained wMDS to an interval with a starting point at 0.
}
\details{
Centres the configuration on zero and calculates the median distance of the points from the origin.
Finds the largest gap in the spherical configuration and assigns the marker on the right hand side of it angle 0. 
Converts Cartesian coordinates to polar coordinates and projects points onto 
the arc centred on 0 with radius the median distance from the origin.
}
\examples{
# M and lod should be n x n symmetric matrices of the same dimensions where
# n is the number markers to be analysed
\dontrun{
mds1<-smacofSphere(M,ndim=2,algorithm=dual,weightmat=lod,penalty=100)
pol<-map.to.interval (m1,n)
}
}
\seealso{
\code{\link{convert.polar}}
}
