% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.functions.R, R/plot.functions.R
\name{mb.nodesplit}
\alias{mb.nodesplit}
\alias{plot.mb.nodesplit}
\title{Perform node-splitting on a MBNMA time-course network}
\usage{
mb.nodesplit(network, comparisons = mb.nodesplit.comparisons(network),
  nodesplit.parameters = "all", fun = "linear", user.fun = NULL,
  beta.1 = list(pool = "rel", method = "common"), beta.2 = NULL,
  beta.3 = NULL, beta.4 = NULL, ...)

\method{plot}{mb.nodesplit}(x, plot.type = NULL, params = NULL, ...)
}
\arguments{
\item{network}{An object of class \code{mb.network}.}

\item{comparisons}{A data frame specifying the comparisons to be split (one row per comparison).
The frame has two columns indicating each treatment for each comparison: \code{t1} and \code{t2}.}

\item{nodesplit.parameters}{A character vector of named time-course parameters on which to
node-split (e.g. c("beta.1", "beta.2")). Can use "all" to split on all time-course parameters.}

\item{fun}{is a character specifying a functional form to be assigned to the
time-course. Options are given in \code{details}.}

\item{user.fun}{A character specifying any relationship including \code{time} and
one/several of: \code{alpha}, \code{beta.1}, \code{beta.2}, \code{beta.3}, \code{beta.4}.}

\item{beta.1}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.2}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.3}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.4}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{...}{Arguments to be sent to \code{mb.run()}}

\item{x}{An object of \code{class("mb.nodesplit")}}

\item{plot.type}{A character string that can take the value of \code{"forest"} to plot
only forest plots, \code{"density"} to plot only density plots, or left as \code{NULL} (the
default) to plot both types of plot.}

\item{params}{A character vector corresponding to a time-course parameter(s) for which to plot results.
If left as \code{NULL} (the default), nodes-split results for all time-course parameters will be plotted.}
}
\value{
A an object of \code{class("mb.nodesplit")} that is a list containing elements
\code{d.X.Y} (treatment 1 = \code{X}, treatment 2 = \code{Y}). Each element (corresponding to each
comparison) contains additional numbered elements corresponding to each parameter in the
time-course function on which node splitting was performed. These elements then contain:
\itemize{
\item \code{overlap matrix} MCMC results for the difference between direct and indirect evidence
\item \code{p.values} Bayesian p-value for the test of consistency between direct and indirect evidence
\item \code{quantiles}
\item \code{forest.plot}
\item \code{density.plot}
\item \code{direct} MCMC results for the direct evidence
\item \code{indirect} MCMC results for the indirect evidence
}

Plots the desired graph(s) and returns an object (or list of objects if
\code{plot.type=NULL}) of \code{class(c("gg", "ggplot"))}, which can be edited using \code{ggplot} commands.
}
\description{
Within a MBNMA time-course network, split contributions into direct and indirect evidence and test
for consistency between them. Closed loops of treatments in which it is possible to test for
consistency are those in which direct and indirect evidence are available from independent sources
van Valkenhoef \insertCite{vanvalkenhoef2016;textual}{MBNMAtime}.
}
\details{
The S3 method \code{plot()} on an \code{mb.nodesplit} object generates either
forest plots of posterior medians and 95\% credible intervals, or density plots
of posterior densities for direct and indirect evidence.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot outputs from nodesplit models
}}

\examples{
\donttest{
# Create mb.network object
network <- mb.network(osteopain)

# Identify comparisons informed by direct and indirect evidence
splits <- mb.nodesplit.comparisons(network)

# Fit an exponential time-course MBNMA
result <- mb.nodesplit(network, comparisons=splits, nodesplit.parameters="all",
  fun="exponential",
  beta.1=list(pool="rel", method="common"))

# Fit an emax time-course MBNMA with a node-split on emax parameters only
result <- mb.nodesplit(network, comparisons=splits, nodesplit.parameters="beta.1",
  fun="emax",
  beta.1=list(pool="rel", method="random"),
  beta.2=list(pool="rel", method="common")
  )

# Inspect results
print(result)
summary(result)

# Plot results
plot(result)
}
}
\references{
\insertAllCited
}
