% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{norm2lnorm}
\alias{norm2lnorm}
\title{Convert normal distribution parameters to corresponding log-normal distribution parameters}
\usage{
norm2lnorm(m, v)
}
\arguments{
\item{m}{Mean of the normal distribution}

\item{v}{Variance of the normal distribution}
}
\value{
A vector of length two. The first element is the mean and the second element is the variance
of the log-normal distribution
}
\description{
Converts mean and variance of normal distribution to the parameters for a log-normal
distribution with the same mean and variance
}
\examples{

norm <- rnorm(1000, mean=5, sd=2)
params <- norm2lnorm(5, 2^2)
lnorm <- rlnorm(1000, meanlog=params[1], sdlog=params[2]^0.5)

# Mean and SD of lnorm is equivalent to mean and sd of norm
mean(lnorm)
sd(lnorm)

}
