% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.functions.R
\name{changepd}
\alias{changepd}
\title{Update model fit statistics depending on calculation for pD}
\usage{
changepd(model, jagsdata = NULL, pd = "pv", likelihood = NULL, type = "dose")
}
\arguments{
\item{model}{A model object of class \code{"rjags"}}

\item{jagsdata}{A list object containing data used to estimate \code{model}}

\item{pd}{Can take either:
\itemize{
\item \code{pv} only pV will be reported (as automatically outputted by \code{R2jags}).
\item \code{plugin} calculates pD by the plug-in
method \insertCite{spiegelhalter2002}{MBNMAdose}. It is faster, but may output negative
non-sensical values, due to skewed deviances that can arise with non-linear models.
\item \code{pd.kl} calculates pD by the Kullback-Leibler divergence \insertCite{plummer2008}{MBNMAdose}. This
will require running the model for additional iterations but is a more robust calculation for the effective
number of parameters in non-linear models.
\item \code{popt} calculates pD using an optimism adjustment which allows for calculation
of the penalized expected deviance \insertCite{plummer2008}{MBNMAdose}.
}}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{type}{Can take either \code{"dose"} for a dose-response MBNMA or \code{"time"} for a
time-course MBNMA (this accounts for multiple observations within an arm)}
}
\value{
A list containing \code{pd} (effective number of parameters calculated using the method
specified in arguments), \code{deviance} (the posterior median of the total residual deviance)
and \code{dic} (the model DIC)
}
\description{
Update model fit statistics depending on calculation for pD
}
