% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.functions.R
\name{rank.mbnma.predict}
\alias{rank.mbnma.predict}
\title{Rank predicted doses of different agents}
\usage{
\method{rank}{mbnma.predict}(x, direction = 1, rank.doses = NULL, ...)
}
\arguments{
\item{x}{An object on which to apply the rank method}

\item{direction}{Indicates whether negative responses are better (taking the
value \code{-1}) or positive responses are better (taking the value \code{1})}

\item{rank.doses}{A list of numeric vectors. Each named element corresponds to an
agent (as named/coded in \code{predict}), and each number within the vector for that element corresponds to the dose
for that agent. Doses of agents specified in \code{rank.doses} \strong{must} be a subset of those
for which responses have been predicted in \code{predict}. If left as \code{NULL} (the default)
then all doses of all agents in \code{predict} will be ranked.}

\item{...}{Arguments to be passed to methods}
}
\value{
An object of \code{class("mbnma.rank")} which is a list containing a summary data
frame, a matrix of rankings for each MCMC iteration, and a matrix of probabilities
that each agent has a particular rank, for each parameter that has been ranked.
}
\description{
Rank predicted doses of different agents
}
\details{
If \code{predict} contains multiple predictions at dose=0, then only the first of these
will be included, to avoid duplicating rankings.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

# Rank predictions from a linear dose-response MBNMA
linear <- mbnma.run(network, fun="linear")
pred <- predict(linear, E0 = 0.5)
rank <- rank(pred)
summary(rank)

# Rank selected predictions from an Emax dose-response MBNMA
emax <- mbnma.emax(network, emax="rel", ed50="rel", method="random")
doses <- list("eletriptan"=c(0,1,2,3), "rizatriptan"=c(0.5,1,2))
pred <- predict(emax, E0 = "rbeta(n, shape1=1, shape2=5)",
            exact.doses=doses)
rank <- rank(pred,
            rank.doses=list("eletriptan"=c(0,2), "rizatriptan"=2))

# Print and generate summary data frame for `mbnma.rank` object
summary(rank)
print(rank)

# Plot `mbnma.rank` object
plot(rank)
}

}
