% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{add_index}
\alias{add_index}
\title{Add arm indices and agent identifiers to a dataset}
\usage{
add_index(data.ab)
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{dose} Numeric data indicating the dose (must take positive values)
\item \code{agent} Agent identifiers (can be numeric, factor or character)
\item \code{y} Numeric data indicating the aggregate response for a continuous outcome. Required for
continuous data.
\item \code{se} Numeric data indicating the standard error for a given observation. Required for
continuous data.
\item \code{r} Numeric data indicating the number of responders within a study arm. Required for
binomial or poisson data.
\item \code{N} Numeric data indicating the total number of participants within a study arm. Required for
binomial data
\item \code{E} Numeric data indicating the total exposure time for participants within a study arm. Required
for poisson data.
\item \code{class} An optional column indicating a particular class code. Agents with the same identifier
must also have the same class code.
}}
}
\value{
A data frame similar to \code{data.ab} but with additional columns:
\itemize{
\item \code{arm} Arm identifiers coded for each study
\item \code{narm} The total number of arms in each study
}

If \code{agent} or \code{class} are non-numeric or non-sequential (i.e. with missing numeric codes),
agents/classes in the returned data frame will be numbered and recoded to enforce sequential
numbering (a warning will be shown stating this).
}
\description{
Adds arm indices (\code{arms}, \code{narms}) to a dataset and adds numeric identifiers for
agent and class (if included in the data).
}
\examples{
# Add indices to triptans headache dataset
data.ab <- add_index(HF2PPITT)

}
