% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNearestNeighborModel.r
\name{KNearestNeighborModel}
\alias{KNearestNeighborModel}
\title{K nearest neighbor model}
\arguments{
\item{SplitRatio}{Train and test split ratio. A value greater or equal to zero and less than one.}

\item{CV}{The number of folds for cross-validation. It should be greater than one.}

\item{K}{The number of nearest neighbors.}

\item{NCores}{The number of cores for parallel computing.}

\item{NewData}{A methylation beta values input from the ReadMethylFile function.}
}
\value{
A list
}
\description{
A function to train a K nearest neighbor model to classify medulloblastoma subgroups using DNA methylation beta values (Illumina Infinium HumanMethylation450). Prediction is followed by training if new data is provided.
}
\examples{
set.seed(111)
knn <- KNearestNeighborModel(SplitRatio = 0.8,
                             CV = 3,
                             K = 3,
                             NCores = 1,
                             NewData = NULL)
}
