% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupportVectorMachineModel.r
\name{SupportVectorMachineModel}
\alias{SupportVectorMachineModel}
\title{Support vector machine model}
\arguments{
\item{SplitRatio}{Train and test split ratio. A value greater or equal to zero and less than one.}

\item{CV}{The number of folds for cross-validation. It should be greater than one.}

\item{NCores}{The number of cores for parallel computing.}

\item{NewData}{A methylation data from the ReadMethylFile function.}
}
\value{
A list
}
\description{
A function to train a support vector machine model to classify medulloblastoma subgroups using the DNA methylation dataset (Illumina Infinium HumanMethylation450). Prediction is followed by training if new data is provided.
}
\examples{
set.seed(56)
svm <- SupportVectorMachineModel(SplitRatio = 0.8,
                                 CV = 3,
                                 NCores = 1,
                                 NewData = NULL)
}
