% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_2d_mass.R
\name{kde_1d}
\alias{kde_1d}
\alias{print.kde_1d}
\alias{plot.kde_1d}
\title{One-dimensional Kernel Density Estimate}
\usage{
kde_1d(
  x,
  bw = bw.nrd0,
  kernel = c("gaussian", "biweight", "cosine", "epanechnikov", "logistic", "optCosine",
    "rectangular", "squaredCosine", "triangular", "tricube", "triweight", "uniform"),
  n = 512,
  limits = c(rx[1] - cut * bw, rx[2] + cut * bw),
  cut = 3,
  na.rm = FALSE,
  adjust = 1,
  fold = FALSE,
  ...
)

\method{print}{kde_1d}(x, ...)

\method{plot}{kde_1d}(
  x,
  ...,
  col = "steel blue",
  las = 1,
  xlab = bquote(x == italic(.(x$data_name))),
  ylab = expression(kde(italic(x)))
)
}
\arguments{
\item{x}{A numeric vector for which the kde is required or (in methods)
an object of class \code{"kde_1d"}}

\item{bw}{The bandwidth or the bandwidth function.}

\item{kernel}{The kernel function, specified either as a character string or as
an R function. Partial matching of the character string is allowed.}

\item{n}{Integer, the number of equally-spaced values in the abscissa of the kde}

\item{limits}{numeric vector of length 2.  Prescribed x-range limits for the
x-range of the result.  May be infinite, but infinite values will be
pruned back to an appropriate value as determined by the data.}

\item{cut}{The number of bandwidths beyond the range of the input x-values to use}

\item{na.rm}{Logical value: should any missing values in x be silently removed?}

\item{adjust}{numeric value: a multiplier to be applied to the computed bandwidth.}

\item{fold}{Logical value: should the kde be estimated beyond the prescribed limits
for the result and 'folded back' to emulate the effect of having known
range boundaries for the underlying distribution?}

\item{...}{currently ignored, except in method functions}

\item{las, col, xlab, ylab}{base graphics parameters}
}
\value{
A list of results specifying the result of the kde computation, of class \code{"kde_1d"}
}
\description{
A pure R implementation of an approximate one-dimensional KDE, similar
to \code{\link[stats]{density}} but using a different algorithm not involving
\code{\link[stats]{fft}}.  Two extra facilities are provided, namely
(a) the kernel may be given either as a character string to select one of a
number of kernel functions provided, or a user defined R function, and (b) the
kde may be fitted beyond the prescribed limits for the result, and folded back
to emulate the effect of having known bounds for the distribution.
}
\examples{
set.seed(1234)
u <- runif(5000)
kdeu0 <- kde_1d(u, limits = c(-Inf, Inf))
kdeu1 <- kde_1d(u, limits = 0:1, kernel = "epan", fold = TRUE)
plot(kdeu0, col = 4)
lines(kdeu1, col = "dark green")
fun <- function(x) (0 < x & x < 1) + 0
curve(fun, add=TRUE, col = "grey", n = 1000)
}
