% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{mixed}
\alias{mixed}
\alias{mixed.default}
\alias{print.mixed}
\alias{summary.mixed}
\alias{mixed.default}
\alias{print.mixed}
\alias{summary.mixed}
\title{The MARX estimation function}
\usage{
mixed(y, x, p_C, p_NC)

\method{mixed}{default}(y, x, p_C, p_NC)

\method{print}{mixed}(x, ...)

\method{summary}{mixed}(object, ...)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p_C}{Number of lags to be included.}

\item{p_NC}{Number of leads to be included.}

\item{...}{Other parameters.}

\item{object}{An object of the class "mixed".}
}
\value{
An object of class \code{"mixed"} is a list containing the following components:

\item{coefficients}{Vector of estimated coefficients.}

\item{se}{Standard errors of estimated coefficients.}

\item{df.residual}{Degrees of freedom residuals.}

\item{residuals}{Residuals.}

\item{fitted.values}{Fitted values.}

\item{order}{Vector containing (r,s,q), i.e. causal order r, noncausal order s, number of exogenous regressors q.}
}
\description{
This function allows you to estimate mixed causal-noncausal MARX models by t-MLE (compatible with most functions in lm() class).
}
\examples{
data <- sim.marx(c('t',1,1), c('t',1,1),100,0.5,0.4,0.3)
object <- mixed(data$y, data$x, 1, 1)
class(object) <- "mixed"
summary(object)
}
\keyword{causal-noncausal}
\keyword{estimation}
