% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_04_MODALITY_ANALYSIS_2_1_PropModality_Doughnut.R
\name{PropModality.Doughnut}
\alias{PropModality.Doughnut}
\title{Modality Proportion for a Given Event Type(s).}
\usage{
PropModality.Doughnut(MarvelObject, modality.column, modality.type, event.type)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{AssignModality} function.}

\item{modality.column}{Character string. Can take the value \code{"modality"}, \code{"modality.var"} or \code{"modality.bimodal.adj"}. Please refer to \code{AssignModality} function help page for more details.}

\item{modality.type}{Character string. \code{basic} indicates that only the main modalities (included, excluded, bimodal, middle, multimodal) are analysed. Sub-modalities (primary and dispersed) will be merged. \code{complete} indicates that both main and sub-modalities are analysed. Sub-modalities will not be merged.}

\item{event.type}{Character string. To indicate which event type to analyse. Can take the value \code{"SE"}, \code{"MXE"}, \code{"RI"}, \code{"A5SS"} or \code{"A3SS"}. Specify \code{"all"} to include all event types.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot name \code{$Modality$Prop$DoughnutChart}.
}
\description{
\code{PropModality.Doughnut} tabulates and plots the proportion of each modality for a specified splicing event type(s).
}
\details{
This function tabulates and plots the proportion of each modality for a specified splicing event type(s).
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- PropModality.Doughnut(MarvelObject=marvel,
                                modality.column="modality.bimodal.adj",
                                modality.type="basic",
                                event.type=c("SE", "MXE", "RI", "A5SS", "A3SS")
                                )

# Check output
marvel$Modality$Prop$DoughnutChart$Table
marvel$Modality$Prop$DoughnutChart$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
