% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCurve.R
\name{fitCurve}
\alias{fitCurve}
\title{Fit dose-response curves}
\usage{
fitCurve(
  spec,
  unit = c("M", "mM", "uM", "nM", "pM", "fM"),
  varFilterMethod = c("mean", "median", "q25", "q75", "none"),
  monoisotopicFilter = FALSE,
  averageMethod = c("mean", "median", "sum"),
  normMz = NULL,
  normTol = 0.1,
  alignTol = 0.01,
  binTol = 2e-04,
  SNR = 3,
  halfWindowSize = 3,
  allowNoMatches = TRUE,
  normMeth = c("mz", "TIC", "PQN", "median", "none"),
  SinglePointRecal = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{spec}{List of MALDIquant::MassSpectrum}

\item{unit}{Character, unit of concentration. Used to calculate the concentration in Moles so that pIC50 is correct.
Set to "M" if you dont want changes in your concentrations.}

\item{varFilterMethod}{Character, function applied for high variance filtering. One of the following options \code{mean} (default), \code{median}, \code{q25}, \code{q75} or \code{none} (no filtering).}

\item{monoisotopicFilter}{Logical, filter peaks and just use monoisotopic peaks for curve fit.}

\item{averageMethod}{Character, aggregation method for average mass spectra ("mean" or "median")}

\item{normMz}{Numeric, mz used for normalization AND for single point recalibration.}

\item{normTol}{Numeric, tolerance in Dalton to match normMz}

\item{alignTol}{Numeric, tolerance for spectral alignment in Dalton.}

\item{binTol}{Numeric, tolerance for binning of peaks.}

\item{SNR}{Numeric, signal to noise ratio for peak detection.}

\item{halfWindowSize}{2ction. See \code{MALDIquant::detectPeaks()}.}

\item{allowNoMatches}{Logical, if normMz can not be found in a spectrum, proceed and exclude spectrum or stop}

\item{normMeth}{Character, normalization method. Can either be "TIC", "PQM", "median" or "mz". If "mz" then the normMz is used. If none no normalization is done.}

\item{SinglePointRecal}{Logical, perform single point recalibration to normMz}

\item{verbose}{Logical, print logs to console.}
}
\value{
Object of class \code{MALDIassay}.
The most important slot is \code{fits} which contains the IC50 curve fits.
}
\description{
Fit dose-response curves
}
\examples{
data(Blank2022spec)

fitCurve(spec = Blank2022spec,
         SinglePointRecal = TRUE, 
         normMz = 760.585, 
         alignTol = 0.1, 
         normTol = 0.1,
         varFilterMethod = "mean") 
}
