% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeByFactor.R
\name{normalizeByFactor}
\alias{normalizeByFactor}
\title{Apply normalization factors to spectra}
\usage{
normalizeByFactor(spec, factors)
}
\arguments{
\item{spec}{List of MALDIquant::MassSpectrum or MALDIquant::MassPeaks}

\item{factors}{Numeric vector of normalization factors. See getNormFactors().}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{        List of normalized Spectra or Peaks
}\if{html}{\out{</div>}}
}
\description{
Apply normalization factors to spectra
}
\examples{
#' data(Blank2022peaks)
normFactors <-  getNormFactors(peaks2df(Blank2022peaks), 
                               targetMz = 760.585, 
                               tol = 0.1, 
                               tolppm = FALSE)
normPeaks <- normalizeByFactor(Blank2022peaks, 
                               normFactors$norm_factor)
}
