% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNormFactors.R
\name{getNormFactors}
\alias{getNormFactors}
\title{Get normalization factors from peak data.frame}
\usage{
getNormFactors(peaksdf, targetMz, tol, tolppm = TRUE, allowNoMatch = TRUE)
}
\arguments{
\item{peaksdf}{data.frame with peaks information as generated by peaks2df()}

\item{targetMz}{Numeric, target mass}

\item{tol}{Numeric, tolerance around targetMz}

\item{tolppm}{Logical, is the tolerance provided in ppm (TRUE) or Daltion (FALSE)}

\item{allowNoMatch}{Logical, stop if targetMz is not fround in single spectrum?
If TRUE spectra without targetMz match will be excluded.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{         List with two entries:
                                  norm_factor The normalization factor for each spectrum
                                  specIdx     The index of the spectra with a match for targetMz
}\if{html}{\out{</div>}}
}
\description{
Get normalization factors from peak data.frame
}
\examples{
data(Blank2022peaks)
getNormFactors(peaks2df(Blank2022peaks), targetMz = 760.585, tol = 0.1, tolppm = FALSE)
}
