/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.task.create.NewNetworkSelectedNodesAndEdgesTaskFatory;
import org.cytoscape.work.swing.DialogTaskManager;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CytoscapeResultViewerPanel;

public class ExtractClusterAction
extends AbstractAction {
    protected CytoscapeResultViewerPanel resultViewer;

    public ExtractClusterAction(CytoscapeResultViewerPanel panel) {
        super("Extract selected cluster(s)");
        this.resultViewer = panel;
        this.putValue("MnemonicKey", 69);
    }

    public void actionPerformed(ActionEvent event) {
        List<CyNode> selectedNodes = this.resultViewer.getSelectedCytoscapeNodeSet();
        CyNetwork network = this.resultViewer.getNetwork();
        ClusterONECytoscapeApp app = this.resultViewer.getCytoscapeApp();
        if (network == null) {
            app.showErrorMessage("Cannot create network representation for the cluster:\nThe parent network has already been destroyed.");
            return;
        }
        this.resultViewer.selectNodes(selectedNodes);
        NewNetworkSelectedNodesAndEdgesTaskFatory taskFactory = this.resultViewer.getCytoscapeApp().getService(NewNetworkSelectedNodesAndEdgesTaskFatory.class);
        if (taskFactory == null) {
            app.showBugMessage("Cannot create network representation for the cluster:\nNew network creation factory is not registered.");
            return;
        }
        DialogTaskManager taskManager = this.resultViewer.getCytoscapeApp().getService(DialogTaskManager.class);
        if (taskManager == null) {
            app.showBugMessage("Cannot create network representation for the cluster:\nDialog task manager is not registered.");
            return;
        }
        taskManager.execute(taskFactory.createTaskIterator(network));
    }
}

