% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcox_test_report.R
\name{wilcox_test_report}
\alias{wilcox_test_report}
\title{Print Wilcoxon Rank Sum and Signed Rank Tests reprot}
\usage{
wilcox_test_report(
  data,
  treatment_col,
  value_col,
  paired = FALSE,
  subject_col = NULL,
  report = TRUE
)
}
\arguments{
\item{data}{Data frame containing the treatment, value and other information.}

\item{treatment_col}{Numeric indicating where treatment locates (column number) in data.}

\item{value_col}{Numeric indicating where treatment value (column number) in data.}

\item{paired}{Logical indicating whether you want a paired test.}

\item{subject_col}{Only meaningful when Pair is ture. Numeric indicating where subject of treatment (column number) in data.}

\item{report}{Logical. If print report to console. Default:TRUE}
}
\value{
wilcox_test_report returns data frame of basic data description.
}
\description{
Print Wilcoxon Rank Sum and Signed Rank Tests reprot
}
\examples{
{
  # Data preparation
  testdata <- data.frame(
    treatment = c(rep("A", 6), rep("B", 6)),
    subject = rep(1:6, 2),
    value = c(rnorm(6, 2), rnorm(6, 1))
  )

  # Wilcoxon test (unpaired)
  wilcox_result <- wilcox_test_report(
    data = testdata,
    treatment_col = 1,
    value_col = 3
  )

  # Wilcoxon signed rank test (paired)
  wilcox_result <- wilcox_test_report(
    data = testdata,
    treatment_col = 1,
    value_col = 3,
    paired = TRUE,
    subject_col = 2
  )

  ### Basic data description ###
  print(wilcox_result)
}
}
