% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessing.R
\name{dataProcessing}
\alias{dataProcessing}
\title{Process mzXML files: peakpicking and deisotoping}
\usage{
dataProcessing(
  file,
  mslevel,
  polarity,
  dmzgap = 50,
  drtgap = 25,
  ppm = TRUE,
  minpeak,
  maxint = 1e+09,
  dmzdens,
  drtdens = 20,
  merged = FALSE,
  drtsmall,
  drtfill = 5,
  drttotal = 100,
  recurs = 4,
  weight,
  SB,
  SN = 2,
  minint,
  ended = 2,
  removeIsotopes = TRUE,
  rttolIso = 2,
  ppmIso = 20
)
}
\arguments{
\item{file}{path of the mzXML input file.}

\item{mslevel}{numeric value indicating if data belongs to level 1 (fullMS)
or level 2 (MS/MS).}

\item{polarity}{character value: negative or positive.}

\item{dmzgap}{enviPick parameter. 50 by default.}

\item{drtgap}{enviPick parameter. 25 by default.}

\item{ppm}{logical value. TRUE if dmzdens was set in ppm and FALSE if it was
in as an absolute value. TRUE by default.}

\item{minpeak}{minimum number of measurements required within the RT window
of drtsmall. Optional. By default, 5 when mslevel = 1 and 4 when mslevel = 2.}

\item{maxint}{EIC cluster with measurements above this intensity are kept,
even if they do not fulfill minpeak. 1E9 by default.}

\item{dmzdens}{maximum measurement deviation (+/-) of m/z from its mean
within each EIC. Optional. By default, 15 when mslevel = 1 and 30 when
mslevel = 2.}

\item{drtdens}{RT tolerance for clustering. Optional. 20 by default.}

\item{merged}{merge EIC cluster of comparable m/z. Logical. FALSE by default.}

\item{drtsmall}{peak definition - RT window of a peak. Optional. By default,
100 when mslevel = 1 and 30 when mslevel = 2.}

\item{drtfill}{maximum RT gap length to be filled. 5 by default.}

\item{drttotal}{maximum RT length of a single peak. 100 by default.}

\item{recurs}{maximum number of peaks within one EIC. 3 by default.}

\item{weight}{weight for assigning measurements to a peak. Optional.
By default, 1 when mslevel = 1 and 2 when mslevel = 2.}

\item{SB}{signal-to-base ratio. Optional. By default, 3 when mslevel = 1
and 2 when mslevel = 2.}

\item{SN}{signal-to-noise ratio. 2 by default.}

\item{minint}{minimum intensity of a peakr. Optional. By default, 1000 when
mslevel = 1 and 100 when mslevel = 2.}

\item{ended}{within the peak detection recursion set by argument recurs,
how often can a peak detection fail to end the recursion?. 2 by default.}

\item{removeIsotopes}{logical. If TRUE, only isotopes identified as M+0, are
kept when mslevel = 1, and M+0 or unknown when mslevel = 2. TRUE by default.
If FALSE, an additional column is added to the peak list to inform about
isotopes.}

\item{rttolIso}{numeric. Time windows for isotope matching.}

\item{ppmIso}{numeric. Mass tolerance for isotope matching.}
}
\value{
List with two data frames: peaklist, with 4 columns (m.z, RT, int,
and peakID) and rawScan, with all the scans information in 5 columns (m.z,
RT, int, peakID and Scan). PeakID columns links both data frames: extracted
peaks and raw data. The Scan column indicates the scan number (order) to which
each row of the rawScans data frame belong.
}
\description{
Process mzXML files: peak-picking using enviPick and deisotoping
using an adaptation of the CAMERA algorithm.
}
\details{
This function executes 2 steps: 1) peak-picking using enviPick
package and 2) it searches isotopes using an adaptation of the CAMERA
algorithm. If mslevel = 1 and remove isotopes is set as TRUE, only ions with
more than 1 isotope are kept.
}
\examples{
\dontrun{
dataProcessing("input_file.mzXML", mslevel = 1, polarity = "positive")
}

}
\references{
https://cran.r-project.org/web/packages/enviPick/index.html

Kuhl C, Tautenhahn R, Boettcher C, Larson TR ans Neumann S (2012). "CAMERA:
an integrated strategy for compound spectra extraction and annotation of
liquid chromatography-mass spectrometry data sets." Analytical Chemistry, 84,
pp. 283-289. htto://pubs.acs.org/doi/abs/10.1021/ac202450g.
}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
