% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowLinkedMatrix.R
\docType{class}
\name{RowLinkedMatrix-class}
\alias{RowLinkedMatrix}
\alias{RowLinkedMatrix-class}
\title{An S4 class to represent a row-linked
\code{\link[=LinkedMatrix-class]{LinkedMatrix}}.}
\description{
This class treats a list of matrix-like objects that are linked together by
rows and have the same number of columns similarly to a regular \code{matrix}
by implementing key methods such as \code{[} and \code{[<-} for extracting
and replacing matrix elements, \code{dim} to retrieve dimensions, and
\code{dimnames} and \code{dimnames<-} to retrieve and set dimnames. Each list
element is called a node and can be extracted or replaced using \code{[[} and
\code{[[<-}. A matrix-like object is one that has two dimensions and
implements at least \code{dim} and \code{[}.
}
\details{
There are several ways to create an instance of this class: either by using
one of the constructors
\code{\link[=initialize,RowLinkedMatrix-method]{RowLinkedMatrix(...)}} or
\code{\link[=initialize,RowLinkedMatrix-method]{new("RowLinkedMatrix",...)}},
or by using the more general \code{\link{LinkedMatrix}} function that
constructs objects of certain dimensions with a configurable number and type
of nodes.
}

