\name{LindleyR-package}
\alias{LindleyR-package}
\docType{package}
\title{
Overview of the LindleyR package
}
\description{The \pkg{LindleyR} R package implements the probability density function, quantile function, cumulative distribution function, random number generation and the hazard rate function for the continuous one-parameter Lindley distribution as well as for 15 of its modifications. Also is it possible to draw censored random samples, with a desired censoring rate, when the event times are any R probability distribution.
The one-parameter Lindley, uniform and exponential are the distributions that can be used as the censoring distributions.
}
\details{

\code{\link[LindleyR]{EXPLindley}:} implements the [dqprh]explindley functions for the exponentiated Lindley distribution.

\code{\link[LindleyR]{EXPPLindley}:} implements the [dqprh]expplindley functions for the exponentiated power Lindley distribution.

\code{\link[LindleyR]{EXTILindley}:} implements the [dqprh]extilindley functions for the extended inverse Lindley distribution.

\code{\link[LindleyR]{EXTLindley}:} implements the [dqprh]extlindley functions for the extended Lindley distribution.

\code{\link[LindleyR]{EXTPLindley}:} implements the [dqprh]extplindley functions for the extended power Lindley distribution.

\code{\link[LindleyR]{GENILindley}:} implements the [dqprh]genilindley functions for the generalized inverse Lindley distribution.

\code{\link[LindleyR]{GENLindley}:} implements the [dqprh]genlindley functions for the generalized Lindley distribution.

\code{\link[LindleyR]{ILindley}:} implements the [dqprh]ilindley functions for the inverse Lindley distribution.

\code{\link[LindleyR]{Lindley}:} implements the [dqprh]lindley functions for one-parameter Lindley distribution.

\code{\link[LindleyR]{MOLindley}:} implements the [dqprh]molindley functions for the Marshall-Olkin extended Lindley distribution.

\code{\link[LindleyR]{NWLindley}:} implements the [dqprh]nwlindley functions for the new weighted Lindley distribution.

\code{\link[LindleyR]{PLindley}:} implements the [dqprh]plindley functions for the power Lindley distribution.

\code{\link[LindleyR]{QLindley}:} implements the [dqprh]qlindley functions for the quasi Lindley distribution.

\code{\link[LindleyR]{randcensor}:} generate censored random samples, with a desired censoring rate, from any continuous lifetime distribution supported by R.

\code{\link[LindleyR]{SLindley}:} implements the [dqprh]slindley functions for the two-parameter Lindley distribution.

\code{\link[LindleyR]{TLindley}:} implements the [dqprh]tlindley functions for the transmuted Lindley distribution.

\code{\link[LindleyR]{WLindley}:} implements the [dqprh]wlindley functions for the weighted Lindley distribution.
}

\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}


