% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{applyHook}
\alias{applyHook}
\title{If \code{hook} is a function, apply it to \code{val}, otherwise return \code{val} unchanged}
\usage{
applyHook(hook, val, ...)
}
\arguments{
\item{hook}{(optional) function to apply to \code{val} and the other parameters}

\item{val}{The value to which the hook is applied (ifgiven)}

\item{...}{optional parameters passed to the hook function (if it is a function)}
}
\description{
If \code{hook} is a function, apply it to \code{val}, otherwise return \code{val} unchanged
}
\examples{
applyHook(NULL, 3) # returns 3 unchanged
applyHook(function(x) 2*x, 3) # applies the function, returns 6
applyHook(`+`, 3, 1) # returns 4
}
