% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_pruning}
\alias{opf_pruning}
\title{Executes the pruning algorithm}
\usage{
opf_pruning(
  dataTraining,
  dataEvaluating,
  percentageAccuracy,
  precomputedDistance = NA
)
}
\arguments{
\item{dataTraining}{The training object produced by the opf_split (subGraph object)}

\item{dataEvaluating}{The evaluating object produced by the opf_split (subGraph object)}

\item{percentageAccuracy}{Max percentage of lost accuracy [0,1]}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns a list which contains the classifier model object
}
\description{
Executes the pruning algorithm
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.3,0.2,0.5,0)
T <- X$training
T2 <- X$testing
E <- X$evaluating
Y <- opf_pruning(T,E,0.8)
class <- opf_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
