% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/competitors.R
\name{get_uniqpt}
\alias{get_uniqpt}
\title{Get phonological uniqueness point}
\usage{
get_uniqpt(target, lexicon, sep = " ")
}
\arguments{
\item{target}{Character string containing a target word}

\item{lexicon}{Character vector containing the lexical database}

\item{sep}{Separator in target and lexicon}
}
\value{
Target is not unique: length + 1, else index where target
becomes unique in lexicon
}
\description{
Phonological uniqueness point is the index at which the
target becomes unique in the lexicon
}
\examples{
get_uniqpt("AA R K", c("AA R", "B AA B", "B AA R K"))
}
