#' LexFindR: A package for finding related items and lexical dimensions in a
#' lexicon.
#'
#' This package implements code to identify lexical competitors in a given list
#' of words. We include many of the standard competitor types used in spoken
#' word recognition research, such as functions to find cohorts, neighbors, and
#' rhymes, amongst many others. The package includes documentation for using a
#' variety of lexicon files, including those with form codes made up of multiple
#' letters (i.e., phoneme codes) and also basic orthographies. Importantly, the
#' code makes use of multiple CPU cores and vectorization when possible, making
#' it extremely fast and able to handle large lexicons. Additionally, the
#' package contains documentation for users to easily write new functions,
#' allowing researchers to examine other relationships within a lexicon.
#'
#' @docType package
#' @name LexFindR
#' @keywords internal
NULL
