\name{run.ij}
\alias{run.ij}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Automated leaf area analysis}
\description{
Analyzes leaf area in the target directory automatically, and returns a data frame that contains sample names in the first column and total leaf area (cm2) of the sample (e.g., one individual plant or one ramet) in the second column. Note that run.ij does not count the number of leaves in each image; therefore if the user requires the number of leaves per image, the user must record these values.
}
\usage{
run.ij(path.imagej = NULL, set.memory = 4, set.directory, distance.pixel = 826,
 known.distance = 21, trim.pixel = 20, low.circ = 0, upper.circ = 1,
  low.size = 0.7, upper.size = "Infinity", prefix = "\\\\.|-",log=F,
  check.image=F,save.image=F)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{path.imagej}{
Path to ImageJ. Deafult uses C:/Program Files/ImageJ for Windows, and /Applications/ImageJ for Mac. Linux always needs to specify the path to ImageJ.
}
  \item{set.memory}{
Set memory (GB) for image analysis (default = 4). 
}
  \item{set.directory}{
Set directory that contains leaf images. For example, when the directory named 'leaf_data' is on desktop of Mac, the path can be specified as: set.directory ='~/Desktop/leaf_data'. For Windows: set.directory='C:/Users/<users name>/Desktop/leaf_data'. No default. The path to the target directory that contains leaf images should always be specified. Note that spaces in file or direcotry names are not allowed.  
}
  \item{distance.pixel}{
Number of pixels for the known distance. When leaf images were captured in A4 image size with 100 ppi, the pixel density is roughly equal to 826 pixels per 21 cm. In this case, the calibration scale can be specified as distance.pixel = 826, known.distance =21. 

}
  \item{known.distance}{
Known distance (cm). See distance.pixel.
}

  \item{trim.pixel}{
Number of pixels removed from edges in the analysis. The edges of images are often shaded, which can affect image analysis (i.e., ImageJ may recognize the shaded area as leaf area). The edges of images can be removed by specifying the number of pixels (default = 20). 

}
  \item{low.circ}{
Lower limit for circularity for the image analysis. When the user wants to remove angular objects (e.g., cut petioles, square papers for scale) from the images, the analyzed lower limit of circularity can be increased (default = 0). 

}
  \item{upper.circ}{
Upper limit for circularity for the image analysis (default = 1). See low.circ.
}
  \item{low.size}{
Lower limit for size for the image analysis. Leaf images often contain dirt and dust. To prevent dust from affecting the image analysis, the lower limit of analyzed size can be increased (default = 0.7). 
}
  \item{upper.size}{
Upper limit for size for the image analysis (default = 'Infinity').}
  \item{prefix}{
Regular expression to manage file names. The run.ij combines the leaf area of all images that share the same filename 'prefix', defined as the part of the filename preceding the first hyphen (-) or period (.) that may occur (no hyphen or period is required). For example, the areas of leaf images named A123-1.jpeg, A123-2.jpeg, and A123-3.jpeg would be combined into a single total leaf area (A123). This feature allows the user to treat multiple images as belonging to a single sample, if desired (default = '\\\\.|-'). 
}

 \item{log}{
Should mean leaf areas of each single image kept? (defalt = FALSE)
}
 \item{check.image}{
Whether to disply analyzed images by using ImageJ software (defalt = FALSE). When you choose check.image = TRUE, press any keys to close ImageJ. Note that when check.image = TRUE, the analysis would take considerable time. Note this option may only work on R console.}

 \item{save.image}{
Whether to save analyzed images (defalt = FALSE).}
}

\value{
A data frame of total leaf area for each sample.\cr 

    \item{sample}{
    Name of sample}
    \item{total.leaf.area}{
    Total leaf area of the sample (cm2)}

If you choose log=T, the run.ij function also returns a list of data frames of leaf area for each image.
    \item{area}{
    Area of the sample (cm2)}
}

\author{
Masatoshi Katabuchi <mattocci27@gmail.com>}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{resmerge.ij}}
\code{\link{readtext.ij}}
\code{\link{eximg}} 
}
\examples{
# As long as ImageJ application is installed in the following directory,
# you do not have to specify the path to ImageJ
# /Applications/ImageJ <Mac>
# C:/Program Files/ImageJ <Windows>
# Linux always needs to specify the path to ImageJ. For example, path = "~/ImageJ"

# prepare the target directory that contains example image files
ex.dir <- eximg()
list.files(ex.dir)

#run automated images analysis
run.ij(set.directory = ex.dir, save.image=TRUE)

# note: in this example, analyzed images are exported to a temporary 
# directory, which will be eventually deleted. 
# If you choose your home directory as the target directory, 
# analyzed images will be exported to it.
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line


