% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inivalsMultiUni.R
\name{inivals_MultiUni_NOHARM}
\alias{inivals_MultiUni_NOHARM}
\title{Initial Values with Noharm for one or higher dimension models}
\usage{
inivals_MultiUni_NOHARM(data, size.cluster, model = "2PL",
  find.restrictions = FALSE, correlated = FALSE, canonical = FALSE,
  verbose = FALSE, probit = FALSE)
}
\arguments{
\item{data}{data matrix to get initial values.}

\item{size.cluster}{A vector with dimensionality test.}

\item{model}{"1PL", "2PL" or "3PL"}

\item{find.restrictions}{False by default.}

\item{correlated}{If TRUE, no correlation process is made}

\item{canonical}{Makes Cannonical base for fixed items}

\item{verbose}{True for get information about process in runtime. False in otherwise.}

\item{probit}{False by default.}
}
\description{
Initial Values with Noharm for one or higher dimension models
}
\examples{
\dontrun{
sim = simulate_dichotomous(dim.data = 4,sample.size = 1000,
     size.cluster = c(20,20,20,20),seed_data = 500L)
iniVals = inivals_MultiUni_NOHARM(data = sim$data,
   size.cluster = c(20,20,20,20))
}
}

