% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sun.rise.set}
\alias{sun.rise.set}
\title{Calculates the time of sunrise and sunset}
\usage{
sun.rise.set(datetimes, lat)
}
\arguments{
\item{datetimes}{Vector of dates as \code{POSIXct} or \code{POSIXlt} (see \code{\link{DateTimeClasses}}) format}

\item{lat}{Single latitude value of site. South should be negative, north positive}
}
\value{
A 2-column matrix, first column sunrise, second column sunset, as \link{POSIXct} format.
}
\description{
Calculates the time of sunrise and sunset based on latitude and date.
}
\examples{
sun.rise.set(lat=40.75,datetimes=as.POSIXlt('2013-03-31'))
}
\author{
Luke A. Winslow
}
\references{
Iqbal, Muhammad. 1983. An Introduction to Solar Radiation. Elsevier.
}
\seealso{
\link{is.night}
\link{is.day}
}
\keyword{methods}

