% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoding_functions.R
\name{stateprobs_p}
\alias{stateprobs_p}
\title{Calculate conditional local state probabilities for periodically inhomogeneous HMMs}
\usage{
stateprobs_p(delta, Gamma, allprobs, tod, trackID = NULL, mod = NULL)
}
\arguments{
\item{delta}{initial or stationary distribution of length N, or matrix of dimension c(k,N) for k independent tracks, if \code{trackID} is provided

This could e.g. be the periodically stationary distribution (for each track) as computed by \code{\link{stationary_p}}.}

\item{Gamma}{array of transition probability matrices for each time point in the cycle of dimension c(N,N,L), where L is the length of the cycle.}

\item{allprobs}{matrix of state-dependent probabilities/ density values of dimension c(n, N)}

\item{tod}{(Integer valued) variable for cycle indexing in 1, ..., L, mapping the data index to a generalised time of day (length n).
For half-hourly data L = 48. It could, however, also be day of year for daily data and L = 365.}

\item{trackID}{optional vector of k track IDs, if multiple tracks need to be decoded separately}

\item{mod}{optional model object containing initial distribution \code{delta}, transition probability matrix \code{Gamma}, matrix of state-dependent probabilities \code{allprobs}, and potentially a \code{trackID} variable

If you are using automatic differentiation either with \code{RTMB::MakeADFun} or \code{\link{qreml}} and include \code{\link{forward_p}} in your likelihood function, the objects needed for state decoding are automatically reported after model fitting.
Hence, you can pass the model object obtained from running \code{RTMB::report()} or from \code{\link{qreml}} directly to this function.}
}
\value{
matrix of conditional state probabilities of dimension c(n,N)
}
\description{
Computes
\deqn{\Pr(S_t = j \mid X_1, ..., X_T)}
for periodically inhomogeneous HMMs
}
\examples{
L = 24
beta = matrix(c(-1, 2, -1, -2, 1, -1), nrow = 2, byrow = TRUE)
Gamma = tpm_p(1:L, L, beta, degree = 1)
delta = stationary_p(Gamma, 1)
allprobs = matrix(runif(200), nrow = 100, ncol = 2)
tod = rep(1:24, 5)[1:100]

probs = stateprobs_p(delta, Gamma, allprobs, tod)
}
\seealso{
Other decoding functions: 
\code{\link{stateprobs}()},
\code{\link{stateprobs_g}()},
\code{\link{viterbi}()},
\code{\link{viterbi_g}()},
\code{\link{viterbi_p}()}
}
\concept{decoding functions}
