% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_functions.R
\name{dgmrf2}
\alias{dgmrf2}
\title{Reparametrised multivariate Gaussian distribution}
\usage{
dgmrf2(x, mu = 0, S, lambda, logdetS = NULL, log = FALSE)
}
\arguments{
\item{x}{density evaluation point, either a vector or a matrix}

\item{mu}{mean parameter. Either scalar or vector}

\item{S}{unscaled precision matrix}

\item{lambda}{precision scaling parameter

Can be a vector if \code{x} is a matrix. Then each row of \code{x} is evaluated with the corresponding \code{lambda}.
This is benefitial from an efficiency perspective because the determinant of \code{S} is only computed once.}

\item{logdetS}{Optional precomputed log determinant of the precision matrix \code{S}. If the precision matrix does not depend on parameters, it can be precomputed and passed to the function.}

\item{log}{logical; if \code{TRUE}, densities are returned on the log scale.}
}
\value{
vector of density values
}
\description{
Density function of the multivariate Gaussian distribution reparametrised in terms of its precision matrix (inverse variance).
This implementation is particularly useful for defining the \strong{joint log-likelihood} with penalised splines or i.i.d. random effects that have a multivariate Gaussian distribution with fixed precision/ penalty matrix \eqn{\lambda S}.
As \eqn{S} is fixed and only scaled by \eqn{\lambda}, it is more efficient to precompute the determinant of \eqn{S} (for the normalisation constant) and only scale the quadratic form by \eqn{\lambda}
when multiple spline parameters/ random effects with different \eqn{\lambda}'s but the same penalty matrix \eqn{S} are evaluated.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
x = matrix(runif(30), nrow = 3)

# iid random effects
S = diag(10)
sigma = c(1, 2, 3) # random effect standard deviations
lambda = 1 / sigma^2
d = dgmrf2(x, 0, S, lambda)

# P-splines
L = diff(diag(10), diff = 2) # second-order difference matrix
S = t(L) \%*\% L
lambda = c(1,2,3)
d = dgmrf2(x, 0, S, lambda, log = TRUE)
}
